# Install Resource Tracking 
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041104 - first draft of program based on Install Follow Up Tracking
# 060820 - Added default report layout for resources

# These design notes are intended to explore the problem. They include more than will be 
#   implemented in the initial version.

# Resource Tracking.

# Project specific resources (customers) and cross-project resources (R4GS & contractors)
# Resource Table (First draft of design 041104)
## pre-existing
#     - ID
#	- ShortName
#	- Name
## new
#     - Category
#     - LastName
#     - FirstName
#	- WorkPhone
#	- CellPhone
#	- Email
#	- Title
#     - Skills
#	- Notes

# All project specific lists?
# Distribution Table -- Distribution lists
#    - ID
#    - Name
# DistributionMember Table
#    - DistributionID
#    - ResourceID


# This script must be run against each file to include the new report options.

# If you want to make sure the report types and column types you add don't conflict
#    with new releases of GanttPV, prefix the Name with "xx". For
#    example: "xxDocument", "xxOwner", "xxURL", etc.

debug = 1

def DoAdd():
    # Specified all required Report Types and Column Types
    # It will either add them or update them if they already exist.

    rt = { 'Name': 'Resource', 'TableA': 'Resource', 'TableB': None, 'Also': None, 'AllOrEach': 'both',
            'SuggestedColumns': ',Name;,ShortName;,Category;,Phonetic;,WorkPhone;,CellPhone;,Email;,Notes' }  
    ct = [
    { 'Name': 'ProjectID',    'Label': 'Project\nID',   'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 50  },
    { 'Name': 'Project/Name', 'Label': 'Project\nName', 'DataType': 't', 'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 90  },
    { 'Name': 'ID',           'Label': None,            'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 40  },
    { 'Name': 'Name',         'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
    { 'Name': 'ShortName',    'Label': 'Short\nName',   'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'Category',     'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
  # { 'Name': 'LastName',     'Label': 'Last\nName',    'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
    { 'Name': 'FirstName',    'Label': 'First\nName',   'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'Phonetic',     'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
    { 'Name': 'WorkPhone',    'Label': 'Work\nPhone',   'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
    { 'Name': 'CellPhone',    'Label': 'Cell\nPhone',   'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
    { 'Name': 'Email',        'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 160  },
    { 'Name': 'Skills',       'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
    { 'Name': 'Title',        'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 110  },
    { 'Name': 'Location',     'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
    { 'Name': 'Notes',        'Label': None,            'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
        ]
    Data.AddReportType(rt, ct)

    Data.SetUndo("Install Resource Tracking")

DoAdd()
